/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rs;

import com.artipie.asto.Content;
import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.StandardRs;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class RsWithBody
implements Response {
    private final Response origin;
    private final Content body;

    public RsWithBody(Response origin, CharSequence body, Charset charset) {
        this(origin, ByteBuffer.wrap(body.toString().getBytes(charset)));
    }

    public RsWithBody(CharSequence body, Charset charset) {
        this(ByteBuffer.wrap(body.toString().getBytes(charset)));
    }

    public RsWithBody(ByteBuffer buf) {
        this((Response)StandardRs.EMPTY, buf);
    }

    public RsWithBody(Response origin, byte[] bytes) {
        this(origin, ByteBuffer.wrap(bytes));
    }

    public RsWithBody(Response origin, ByteBuffer buf) {
        this(origin, (Content)new Content.From(Optional.of(Long.valueOf(buf.remaining())), (Publisher)Flowable.just((Object)buf)));
    }

    public RsWithBody(Publisher<ByteBuffer> body) {
        this((Response)StandardRs.EMPTY, body);
    }

    public RsWithBody(Response origin, Publisher<ByteBuffer> body) {
        this(origin, (Content)new Content.From(body));
    }

    public RsWithBody(Content body) {
        this((Response)StandardRs.EMPTY, body);
    }

    public RsWithBody(Response origin, Content body) {
        this.origin = origin;
        this.body = body;
    }

    @Override
    public CompletionStage<Void> send(Connection con) {
        return RsWithBody.withHeaders(this.origin, this.body.size()).send(new ConWithBody(con, (Publisher<ByteBuffer>)this.body));
    }

    public String toString() {
        return String.format("(%s: origin='%s', body='%s')", this.getClass().getSimpleName(), this.origin.toString(), this.body.toString());
    }

    private static Response withHeaders(Response origin, Optional<Long> size) {
        return size.map(val -> new RsWithHeaders(origin, new Headers.From((Map.Entry<String, String>)new ContentLength(String.valueOf(val))), true)).orElse(origin);
    }

    private static final class ConWithBody
    implements Connection {
        private final Connection origin;
        private final Publisher<ByteBuffer> body;

        ConWithBody(Connection origin, Publisher<ByteBuffer> body) {
            this.origin = origin;
            this.body = body;
        }

        @Override
        public CompletionStage<Void> accept(RsStatus status, Headers headers, Publisher<ByteBuffer> none) {
            return this.origin.accept(status, headers, (Publisher<ByteBuffer>)Flowable.fromPublisher(this.body).map(ByteBuffer::duplicate));
        }
    }
}

