/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentFileName;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.slice.KeyFromPath;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class SliceDownload
implements Slice {
    private final Storage storage;
    private final Function<String, Key> transform;

    public SliceDownload(Storage storage) {
        this(storage, KeyFromPath::new);
    }

    public SliceDownload(Storage storage, Function<String, Key> transform) {
        this.storage = storage;
        this.transform = transform;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(CompletableFuture.supplyAsync(new RequestLineFrom(line)::uri).thenCompose(uri -> {
            Key key = this.transform.apply(uri.getPath());
            return this.storage.exists(key).thenCompose(exist -> {
                CompletableFuture<RsWithBody> result = exist != false ? this.storage.value(key).thenApply(content -> new RsFull(RsStatus.OK, (Iterable<Map.Entry<String, String>>)new Headers.From((Map.Entry<String, String>)new ContentFileName((URI)uri)), (Content)content)) : CompletableFuture.completedFuture(new RsWithBody(StandardRs.NOT_FOUND, String.format("Key %s not found", key.string()), StandardCharsets.UTF_8));
                return result;
            });
        }));
    }
}

