/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public final class SliceOptional<T>
implements Slice {
    private final Supplier<? extends T> source;
    private final Predicate<? super T> predicate;
    private final Function<? super T, ? extends Slice> slice;

    public SliceOptional(T source, Predicate<? super T> predicate, Function<? super T, ? extends Slice> slice) {
        this(() -> source, predicate, slice);
    }

    public SliceOptional(Supplier<? extends T> source, Predicate<? super T> predicate, Function<? super T, ? extends Slice> slice) {
        this.source = source;
        this.predicate = predicate;
        this.slice = slice;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> head, Publisher<ByteBuffer> body) {
        T target = this.source.get();
        Response response = this.predicate.test(target) ? this.slice.apply(target).response(line, head, body) : new RsWithStatus(RsStatus.NOT_FOUND);
        return response;
    }
}

