/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http;

import com.artipie.ArtipieException;
import com.artipie.http.rs.RsStatus;
import java.util.Collections;
import java.util.Map;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;

public final class ArtipieHttpException
extends ArtipieException {
    private static final long serialVersionUID = -16695752893817954L;
    private static final Map<String, String> MEANINGS = Collections.unmodifiableMap(new MapOf(new Map.Entry[]{new MapEntry((Object)"400", (Object)"Bad request"), new MapEntry((Object)"401", (Object)"Unauthorized"), new MapEntry((Object)"402", (Object)"Payment Required"), new MapEntry((Object)"403", (Object)"Forbidden"), new MapEntry((Object)"404", (Object)"Not Found"), new MapEntry((Object)"405", (Object)"Method Not Allowed"), new MapEntry((Object)"406", (Object)"Not Acceptable"), new MapEntry((Object)"407", (Object)"Proxy Authentication Required"), new MapEntry((Object)"408", (Object)"Request Timeout"), new MapEntry((Object)"409", (Object)"Conflict"), new MapEntry((Object)"410", (Object)"Gone"), new MapEntry((Object)"411", (Object)"Length Required"), new MapEntry((Object)"412", (Object)"Precondition Failed"), new MapEntry((Object)"413", (Object)"Payload Too Large"), new MapEntry((Object)"414", (Object)"URI Too Long"), new MapEntry((Object)"415", (Object)"Unsupported Media Type"), new MapEntry((Object)"416", (Object)"Range Not Satisfiable"), new MapEntry((Object)"417", (Object)"Expectation Failed"), new MapEntry((Object)"418", (Object)"I'm a teapot"), new MapEntry((Object)"421", (Object)"Misdirected Request"), new MapEntry((Object)"422", (Object)"Unprocessable Entity (WebDAV)"), new MapEntry((Object)"423", (Object)"Locked (WebDAV)"), new MapEntry((Object)"424", (Object)"Failed Dependency (WebDAV)"), new MapEntry((Object)"425", (Object)"Too Early"), new MapEntry((Object)"426", (Object)"Upgrade Required"), new MapEntry((Object)"428", (Object)"Precondition Required"), new MapEntry((Object)"429", (Object)"Too Many Requests"), new MapEntry((Object)"431", (Object)"Request Header Fields Too Large"), new MapEntry((Object)"451", (Object)"Unavailable For Legal Reasons"), new MapEntry((Object)"500", (Object)"Internal Server Error"), new MapEntry((Object)"501", (Object)"Not Implemented")}));
    private final RsStatus code;

    public ArtipieHttpException(RsStatus status) {
        this(status, ArtipieHttpException.meaning(status));
    }

    public ArtipieHttpException(RsStatus status, Throwable cause) {
        this(status, ArtipieHttpException.meaning(status), cause);
    }

    public ArtipieHttpException(RsStatus status, String message) {
        super(message);
        this.code = status;
    }

    public ArtipieHttpException(RsStatus status, String message, Throwable cause) {
        super(message, cause);
        this.code = status;
    }

    public RsStatus status() {
        return this.code;
    }

    private static String meaning(RsStatus status) {
        return MEANINGS.getOrDefault(status.code(), "Unknown");
    }
}

