/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public interface Action {
    public Collection<String> names();

    public static final class ByString {
        private final String action;

        public ByString(String action) {
            this.action = action;
        }

        public Action get() {
            return Stream.of(Standard.values()).filter(item -> item.names().stream().anyMatch(act -> act.equals(this.action))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unrecognized action %s", this.action)));
        }
    }

    public static enum Standard implements Action
    {
        READ{

            @Override
            public Collection<String> names() {
                return Arrays.asList("r", "read", "download", "install");
            }
        }
        ,
        WRITE{

            @Override
            public Collection<String> names() {
                return Arrays.asList("w", "write", "publish", "push", "deploy", "upload");
            }
        }
        ,
        DELETE{

            @Override
            public Collection<String> names() {
                return Arrays.asList("d", "delete");
            }
        };

    }
}

