/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq.multipart;

import com.artipie.http.Headers;
import com.artipie.http.misc.BufAccumulator;
import com.artipie.http.misc.ByteBufferTokenizer;
import com.artipie.http.misc.DummySubscription;
import com.artipie.http.rq.multipart.Completion;
import com.artipie.http.rq.multipart.MultipartHeaders;
import com.artipie.http.rq.multipart.RqMultipart;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class MultiPart
implements RqMultipart.Part,
ByteBufferTokenizer.Receiver,
Subscription {
    private static final int CAP_HEADER = 256;
    private static final int CAP_PART = 1024;
    private static final String DELIM = "\r\n\r\n";
    @GuardedBy(value="lock")
    private final ByteBufferTokenizer tokenizer;
    private final MultipartHeaders hdr;
    private volatile Subscriber<? super ByteBuffer> downstream;
    private volatile boolean head;
    private final Consumer<? super RqMultipart.Part> ready;
    @GuardedBy(value="lock")
    private final BufAccumulator tmpacc;
    private final ExecutorService exec;
    private volatile boolean completed;
    private final Completion<?> completion;
    private final Object lock;
    private volatile long demand;

    MultiPart(Completion<?> completion, Consumer<? super RqMultipart.Part> ready) {
        this.ready = ready;
        this.exec = Executors.newSingleThreadExecutor();
        this.completion = completion;
        this.tokenizer = new ByteBufferTokenizer(this, DELIM.getBytes(), 1024);
        this.hdr = new MultipartHeaders(256);
        this.tmpacc = new BufAccumulator(256);
        this.lock = new Object();
    }

    @Override
    public Headers headers() {
        return this.hdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super ByteBuffer> sub) {
        Object object = this.lock;
        synchronized (object) {
            if (this.downstream != null) {
                sub.onSubscribe((Subscription)DummySubscription.VALUE);
                sub.onError((Throwable)new IllegalStateException("Downstream already connected"));
                return;
            }
            this.downstream = sub;
            sub.onSubscribe((Subscription)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(ByteBuffer next, boolean end) {
        Object object = this.lock;
        synchronized (object) {
            if (this.head) {
                this.nextChunk(next);
            } else {
                this.hdr.push(next);
                if (end) {
                    this.head = true;
                    this.ready.accept(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long amt) {
        if (amt <= 0L) {
            throw new IllegalStateException("Requested amount should be greater than zero");
        }
        if (this.downstream == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.demand = amt == Long.MAX_VALUE || this.demand == Long.MAX_VALUE || amt + this.demand < 0L ? Long.MAX_VALUE : (this.demand += amt);
        }
        this.exec.submit(this::deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.downstream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(ByteBuffer chunk) {
        Object object = this.lock;
        synchronized (object) {
            if (this.head) {
                this.nextChunk(chunk);
            } else {
                this.tokenizer.push(chunk);
                if (this.head) {
                    this.tokenizer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.head) {
                this.tokenizer.close();
            }
            this.completed = true;
            this.exec.submit(this::deliver);
        }
    }

    private void nextChunk(ByteBuffer next) {
        this.tmpacc.write(next);
        if (this.downstream != null) {
            this.exec.submit(this::deliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver() {
        Object object = this.lock;
        synchronized (object) {
            ByteBuffer out;
            while (this.demand > 0L && this.tmpacc.read(out = ByteBuffer.allocate(4096)) >= 0) {
                out.flip();
                this.downstream.onNext((Object)out);
                if (this.demand == Long.MAX_VALUE) continue;
                --this.demand;
            }
            if (this.completed && this.tmpacc.empty()) {
                this.tmpacc.close();
                this.downstream.onComplete();
                this.downstream = null;
                this.exec.shutdown();
                this.completion.itemCompleted();
            }
        }
    }
}

