/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq.multipart;

import com.artipie.http.Headers;
import com.artipie.http.headers.Header;
import com.artipie.http.misc.BufAccumulator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

final class MultipartHeaders
implements Headers {
    private final Object lock = new Object();
    private final BufAccumulator accumulator;
    private volatile Headers cache;

    MultipartHeaders(int cap) {
        this.accumulator = new BufAccumulator(cap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        if (this.cache == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.cache == null) {
                    byte[] arr = this.accumulator.array();
                    String hstr = new String(arr, StandardCharsets.US_ASCII);
                    this.cache = new Headers.From(Arrays.stream(hstr.split("\r\n")).filter(str -> !str.isEmpty()).map(line -> {
                        String[] parts = line.split(":");
                        return new Header(parts[0].trim().toLowerCase(Locale.US), parts[1].trim().toLowerCase(Locale.US));
                    }).collect(Collectors.toList()));
                }
                this.accumulator.close();
            }
        }
        return this.cache.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(ByteBuffer chunk) {
        Object object = this.lock;
        synchronized (object) {
            this.accumulator.write(chunk);
        }
    }
}

