/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.servlet;

import com.artipie.http.Headers;
import com.artipie.http.Slice;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.servlet.ServletConnection;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.cqfn.rio.Buffers;
import org.cqfn.rio.stream.ReactiveInputStream;
import org.reactivestreams.Publisher;

public final class ServletSliceWrap {
    private final Slice target;

    public ServletSliceWrap(Slice target) {
        this.target = target;
    }

    public void handle(AsyncContext ctx) {
        HttpServletResponse rsp = (HttpServletResponse)ctx.getResponse();
        this.handle((HttpServletRequest)ctx.getRequest(), rsp).handle((? super T success, Throwable error) -> {
            if (error != null) {
                Logger.error((Object)this, (String)"Failed to process async request: %[exception]s", (Object[])new Object[]{error});
                rsp.setStatus(500);
                try {
                    PrintWriter writer = rsp.getWriter();
                    writer.println(error.getMessage());
                    error.printStackTrace(writer);
                }
                catch (IOException iex) {
                    Logger.error((Object)this, (String)"Failed to send 500 error: %[exception]s", (Object[])new Object[]{iex});
                }
            }
            ctx.complete();
            return success;
        });
    }

    public CompletionStage<Void> handle(HttpServletRequest req, HttpServletResponse rsp) {
        try {
            URI uri = new URIBuilder(req.getRequestURI()).setCustomQuery(req.getQueryString()).build();
            return this.target.response(new RequestLine(req.getMethod(), uri.toASCIIString(), req.getProtocol()).toString(), ServletSliceWrap.headers(req), (Publisher<ByteBuffer>)new ReactiveInputStream((InputStream)req.getInputStream()).read((Buffers)Buffers.Standard.K8)).send(new ServletConnection(rsp));
        }
        catch (IOException iex) {
            return ServletSliceWrap.failedStage("Servet IO error", iex);
        }
        catch (URISyntaxException err) {
            return ServletSliceWrap.failedStage("Invalid request URI", err);
        }
        catch (Exception exx) {
            return ServletSliceWrap.failedStage("Unexpected servlet exception", exx);
        }
    }

    private static Headers headers(HttpServletRequest req) {
        return new Headers.From(Collections.list(req.getHeaderNames()).stream().flatMap(name -> Collections.list(req.getHeaders(name)).stream().map(val -> new Header((String)name, (String)val))).collect(Collectors.toList()));
    }

    private static CompletionStage<Void> failedStage(String msg, Throwable err) {
        CompletableFuture<Void> failure = new CompletableFuture<Void>();
        failure.completeExceptionally(new CompletionException(msg, err));
        return failure;
    }
}

