/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq;

import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RqParams {
    private final String query;

    public RqParams(URI uri) {
        this(uri.getQuery());
    }

    public RqParams(String query) {
        this.query = query;
    }

    public Optional<String> value(String name) {
        Optional<String> result = this.query == null ? Optional.empty() : StreamSupport.stream(Splitter.on((String)"&").omitEmptyStrings().split((CharSequence)this.query).spliterator(), false).flatMap(param -> {
            String prefix = String.format("%s=", name);
            Stream<Object> value = param.startsWith(prefix) ? Stream.of(param.substring(prefix.length())) : Stream.empty();
            return value;
        }).findFirst();
        return result.map(RqParams::decode);
    }

    private static String decode(String enc) {
        try {
            return URLDecoder.decode(enc, "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new IllegalStateException(err);
        }
    }
}

