/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http;

import com.artipie.ArtipieException;
import com.artipie.http.rs.RsStatus;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class ArtipieHttpException
extends ArtipieException {
    private static final long serialVersionUID = -16695752893817954L;
    private static final Map<String, String> MEANINGS = new ImmutableMap.Builder().put((Object)"400", (Object)"Bad request").put((Object)"401", (Object)"Unauthorized").put((Object)"402", (Object)"Payment Required").put((Object)"403", (Object)"Forbidden").put((Object)"404", (Object)"Not Found").put((Object)"405", (Object)"Method Not Allowed").put((Object)"406", (Object)"Not Acceptable").put((Object)"407", (Object)"Proxy Authentication Required").put((Object)"408", (Object)"Request Timeout").put((Object)"409", (Object)"Conflict").put((Object)"410", (Object)"Gone").put((Object)"411", (Object)"Length Required").put((Object)"412", (Object)"Precondition Failed").put((Object)"413", (Object)"Payload Too Large").put((Object)"414", (Object)"URI Too Long").put((Object)"415", (Object)"Unsupported Media Type").put((Object)"416", (Object)"Range Not Satisfiable").put((Object)"417", (Object)"Expectation Failed").put((Object)"418", (Object)"I'm a teapot").put((Object)"421", (Object)"Misdirected Request").put((Object)"422", (Object)"Unprocessable Entity (WebDAV)").put((Object)"423", (Object)"Locked (WebDAV)").put((Object)"424", (Object)"Failed Dependency (WebDAV)").put((Object)"425", (Object)"Too Early").put((Object)"426", (Object)"Upgrade Required").put((Object)"428", (Object)"Precondition Required").put((Object)"429", (Object)"Too Many Requests").put((Object)"431", (Object)"Request Header Fields Too Large").put((Object)"451", (Object)"Unavailable For Legal Reasons").put((Object)"500", (Object)"Internal Server Error").put((Object)"501", (Object)"Not Implemented").build();
    private final RsStatus code;

    public ArtipieHttpException(RsStatus status) {
        this(status, ArtipieHttpException.meaning(status));
    }

    public ArtipieHttpException(RsStatus status, Throwable cause) {
        this(status, ArtipieHttpException.meaning(status), cause);
    }

    public ArtipieHttpException(RsStatus status, String message) {
        super(message);
        this.code = status;
    }

    public ArtipieHttpException(RsStatus status, String message, Throwable cause) {
        super(message, cause);
        this.code = status;
    }

    public RsStatus status() {
        return this.code;
    }

    private static String meaning(RsStatus status) {
        return MEANINGS.getOrDefault(status.code(), "Unknown");
    }
}

