/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.TokenAuthentication;
import com.artipie.http.headers.Authorization;
import com.artipie.http.rq.RqHeaders;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class BearerAuthScheme
implements AuthScheme {
    public static final String NAME = "Bearer";
    private final TokenAuthentication auth;
    private final String params;

    public BearerAuthScheme(TokenAuthentication auth, String params) {
        this.auth = auth;
        this.params = params;
    }

    @Override
    public CompletionStage<AuthScheme.Result> authenticate(Iterable<Map.Entry<String, String>> headers, String line) {
        return this.user(headers).thenApply(user -> user.map(x$0 -> new Success((Authentication.User)x$0)).orElseGet(() -> new Failure()));
    }

    private CompletionStage<Optional<Authentication.User>> user(Iterable<Map.Entry<String, String>> headers) {
        return new RqHeaders(headers, "Authorization").stream().findFirst().map(Authorization::new).filter(hdr -> hdr.scheme().equals(NAME)).map(hdr -> new Authorization.Bearer(hdr.credentials()).token()).map(this.auth::user).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    private String challenge() {
        return String.format("%s %s", NAME, this.params);
    }

    private class Failure
    implements AuthScheme.Result {
        private Failure() {
        }

        @Override
        public Optional<Authentication.User> user() {
            return Optional.empty();
        }

        @Override
        public String challenge() {
            return BearerAuthScheme.this.challenge();
        }
    }

    private class Success
    implements AuthScheme.Result {
        private final Authentication.User usr;

        Success(Authentication.User user) {
            this.usr = user;
        }

        @Override
        public Optional<Authentication.User> user() {
            return Optional.of(this.usr);
        }

        @Override
        public String challenge() {
            return BearerAuthScheme.this.challenge();
        }
    }
}

