/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.group;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.group.GroupResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public final class GroupSlice
implements Slice {
    private static final Set<RqMethod> BROADCAST_METHODS = Collections.unmodifiableSet(new HashSet<RqMethod>(Arrays.asList(RqMethod.GET, RqMethod.HEAD, RqMethod.OPTIONS, RqMethod.CONNECT, RqMethod.TRACE)));
    private final List<Slice> targets;

    public GroupSlice(Slice ... targets) {
        this(Arrays.asList(targets));
    }

    public GroupSlice(List<Slice> targets) {
        this.targets = Collections.unmodifiableList(targets);
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RqMethod method = new RequestLineFrom(line).method();
        Response rsp = BROADCAST_METHODS.contains((Object)method) ? new GroupResponse(this.targets.stream().map(slice -> slice.response(line, headers, body)).collect(Collectors.toList())) : this.targets.get(0).response(line, headers, body);
        return rsp;
    }
}

