/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq;

import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RqParams {
    private final String query;

    public RqParams(URI uri) {
        this(uri.getQuery());
    }

    public RqParams(String query) {
        this.query = query;
    }

    public Optional<String> value(String name) {
        Optional<String> result = this.query == null ? Optional.empty() : this.findValues(name).findFirst();
        return result;
    }

    public List<? extends String> values(String name) {
        List results = this.query == null ? Collections.emptyList() : this.findValues(name).collect(Collectors.toList());
        return results;
    }

    private Stream<String> findValues(String name) {
        return StreamSupport.stream(Splitter.on((String)"&").omitEmptyStrings().split((CharSequence)this.query).spliterator(), false).flatMap(param -> {
            String prefix = String.format("%s=", name);
            Stream<Object> value = param.startsWith(prefix) ? Stream.of(param.substring(prefix.length())) : Stream.empty();
            return value;
        }).map(RqParams::decode);
    }

    private static String decode(String enc) {
        try {
            return URLDecoder.decode(enc, "UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new IllegalStateException(err);
        }
    }
}

