/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq.multipart;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;

final class State {
    private static final int INIT = 0;
    private static final int PREAMBLE = 1;
    private static final int PART = 2;
    private static final int END = 4;
    private static final int START = 8;
    private static final int EPILOGUE = 16;
    private static final Collection<BiFunction<ByteBuffer, Boolean, Patch>> PATCHERS = Collections.unmodifiableList(Arrays.asList((buf, end) -> Patch.equal(0).addFlags(1), (buf, end) -> Patch.hasFlag(8).removeFlags(8), (buf, end) -> Patch.equal(0).addFlags(8), (buf, end) -> Patch.hasFlag(4).addFlags(8), (buf, end) -> Patch.hasFlag(5).removeFlags(1), (buf, end) -> new Patch(state -> (state & 0x14) == 4, state -> {
        ByteBuffer dup = buf.duplicate();
        int patch = state;
        if (dup.remaining() >= 2 && dup.get() == 45 && dup.get() == 45) {
            patch |= 0x10;
        }
        return patch;
    }), (buf, end) -> new Patch(state -> (state & 4) == 4 != end, state -> {
        int patch = end != false ? state | 4 : state & 0xFFFFFFFB;
        return patch;
    }), (buf, end) -> new Patch(state -> (state & 0x11) == 0).addFlags(2), (buf, end) -> new Patch(state -> (state & 0x11) != 0).removeFlags(2)));
    private volatile int flags;

    State() {
    }

    void patch(ByteBuffer buf, boolean end) {
        PATCHERS.stream().map(factory -> (Patch)factory.apply(buf, end)).filter(patch -> patch.test(this.flags)).forEach(patch -> {
            this.flags = patch.applyAsInt(this.flags);
        });
    }

    boolean shouldIgnore() {
        return (this.flags & 0x11) != 0;
    }

    boolean isInit() {
        return (this.flags & 0) == 0;
    }

    boolean started() {
        return (this.flags & 8) == 8;
    }

    boolean ended() {
        return (this.flags & 4) == 4;
    }

    private static final class Patch
    implements IntPredicate,
    IntUnaryOperator {
        static final Patch ANY = new Patch(state -> true);
        private final IntPredicate predicate;
        private final IntUnaryOperator operator;

        Patch(IntPredicate predicate) {
            this(predicate, state -> state);
        }

        Patch(IntPredicate predicate, IntUnaryOperator operator) {
            this.operator = operator;
            this.predicate = predicate;
        }

        @Override
        public boolean test(int state) {
            return this.predicate.test(state);
        }

        @Override
        public int applyAsInt(int state) {
            return this.operator.applyAsInt(state);
        }

        Patch addFlags(int flags) {
            return new Patch(this.predicate, this.operator.andThen(state -> state | flags));
        }

        Patch removeFlags(int flags) {
            return new Patch(this.predicate, this.operator.andThen(state -> state & ~flags));
        }

        static Patch equal(int val) {
            return new Patch(test -> test == val, state -> state);
        }

        static Patch hasFlag(int flag) {
            return new Patch(test -> (test & flag) == flag, state -> state);
        }

        static Patch hasNoFlag(int flag) {
            return new Patch(test -> (test & flag) == 0, state -> state);
        }
    }
}

