/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rs;

import com.artipie.asto.Content;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.rs.RsStatus;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;

public final class CachedResponse
implements Response {
    private final Response origin;
    private final StatefulConnection con;

    public CachedResponse(Response origin) {
        this.origin = origin;
        this.con = new StatefulConnection();
    }

    @Override
    public CompletionStage<Void> send(Connection connection) {
        return this.con.load(this.origin).thenCompose(self -> self.replay(connection));
    }

    public String toString() {
        return String.format("(%s: state=%s)", this.getClass().getSimpleName(), this.con.toString());
    }

    private static final class StatefulConnection
    implements Connection {
        private volatile RsStatus status;
        private volatile Headers headers;
        private volatile byte[] body;

        private StatefulConnection() {
        }

        @Override
        public CompletionStage<Void> accept(RsStatus stts, Headers hdrs, Publisher<ByteBuffer> bdy) {
            this.status = stts;
            this.headers = hdrs;
            return new PublisherAs(bdy).bytes().thenAccept(bytes -> {
                this.body = bytes;
            });
        }

        public String toString() {
            return String.format("(%s: status=%s, headers=[%s], body=%s)", new Object[]{this.getClass().getSimpleName(), this.status, StreamSupport.stream(this.headers.spliterator(), false).map(header -> String.format("\"%s\": \"%s\"", header.getKey(), header.getValue())).collect(Collectors.joining(", ")), Arrays.toString(this.body)});
        }

        CompletionStage<StatefulConnection> load(Response response) {
            CompletionStage<StatefulConnection> self = this.status == null && this.headers == null && this.body == null ? response.send(this).thenApply(none -> this) : CompletableFuture.completedFuture(this);
            return self;
        }

        CompletionStage<Void> replay(Connection connection) {
            return connection.accept(this.status, this.headers, (Publisher<ByteBuffer>)new Content.From(this.body));
        }
    }
}

