/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.servlet;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.rs.RsStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.servlet.http.HttpServletResponse;
import org.cqfn.rio.WriteGreed;
import org.cqfn.rio.stream.ReactiveOutputStream;
import org.reactivestreams.Publisher;

final class ServletConnection
implements Connection {
    private final HttpServletResponse rsp;

    ServletConnection(HttpServletResponse rsp) {
        this.rsp = rsp;
    }

    @Override
    public CompletionStage<Void> accept(RsStatus status, Headers headers, Publisher<ByteBuffer> body) {
        this.rsp.setStatus(Integer.parseInt(status.code()));
        headers.forEach(kv -> this.rsp.setHeader((String)kv.getKey(), (String)kv.getValue()));
        try {
            return new ReactiveOutputStream((OutputStream)this.rsp.getOutputStream()).write(body, WriteGreed.SYSTEM.adaptive());
        }
        catch (IOException iex) {
            CompletableFuture<Void> failure = new CompletableFuture<Void>();
            failure.completeExceptionally(new CompletionException(iex));
            return failure;
        }
    }
}

