/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rs.RsStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.zip.GZIPOutputStream;
import org.cqfn.rio.Buffers;
import org.cqfn.rio.WriteGreed;
import org.cqfn.rio.stream.ReactiveInputStream;
import org.cqfn.rio.stream.ReactiveOutputStream;
import org.reactivestreams.Publisher;

final class GzipSlice
implements Slice {
    private final Slice origin;

    GzipSlice(Slice origin) {
        this.origin = origin;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return connection -> this.origin.response(line, headers, body).send((status, rsheaders, rsbody) -> GzipSlice.gzip(connection, status, (Publisher<ByteBuffer>)rsbody, rsheaders));
    }

    private static CompletionStage<Void> gzip(Connection connection, RsStatus stat, Publisher<ByteBuffer> body, Headers headers) {
        CompletionStage future;
        try (PipedOutputStream resout = new PipedOutputStream();
             PipedInputStream oinput = new PipedInputStream();
             PipedOutputStream tmpout = new PipedOutputStream(oinput);){
            CompletionStage tmp = CompletableFuture.allOf(new CompletableFuture[0]).thenCompose(nothing -> new ReactiveOutputStream((OutputStream)tmpout).write(body, WriteGreed.SYSTEM));
            PipedInputStream src = new PipedInputStream(resout);
            future = ((CompletableFuture)tmp).thenCompose(nothing -> connection.accept(stat, new Headers.From((Iterable<Map.Entry<String, String>>)headers, "Content-encoding", "gzip"), (Publisher<ByteBuffer>)new Content.From(new ReactiveInputStream((InputStream)src).read((Buffers)Buffers.Standard.K8))));
            try (GZIPOutputStream gzos = new GZIPOutputStream(resout);){
                int length;
                byte[] buffer = new byte[8192];
                while ((length = oinput.read(buffer)) >= 0) {
                    gzos.write(buffer, 0, length);
                }
                gzos.finish();
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
        catch (IOException err) {
            throw new ArtipieIOException(err);
        }
        return future;
    }
}

