/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentFileName;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.slice.KeyFromPath;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class HeadSlice
implements Slice {
    private final Storage storage;
    private final Function<String, Key> transform;
    private final BiFunction<String, Headers, CompletionStage<Headers>> resheaders;

    public HeadSlice(Storage storage) {
        this(storage, KeyFromPath::new);
    }

    public HeadSlice(Storage storage, Function<String, Key> transform) {
        this(storage, transform, (line, headers) -> {
            URI uri = new RequestLineFrom((String)line).uri();
            Key key = (Key)transform.apply(uri.getPath());
            return storage.size(key).thenApply(size -> new Headers.From(new ContentFileName(uri), new ContentLength((Number)size)));
        });
    }

    public HeadSlice(Storage storage, Function<String, Key> transform, BiFunction<String, Headers, CompletionStage<Headers>> resheaders) {
        this.storage = storage;
        this.transform = transform;
        this.resheaders = resheaders;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(CompletableFuture.supplyAsync(new RequestLineFrom(line)::uri).thenCompose(uri -> {
            Key key = this.transform.apply(uri.getPath());
            return this.storage.exists(key).thenCompose(exist -> {
                CompletionStage<Response> result = exist != false ? this.resheaders.apply(line, new Headers.From(headers)).thenApply(hdrs -> new RsWithHeaders((Response)StandardRs.OK, (Headers)hdrs)) : CompletableFuture.completedFuture(new RsWithBody(StandardRs.NOT_FOUND, String.format("Key %s not found", key.string()), StandardCharsets.UTF_8));
                return result;
            });
        }));
    }
}

