/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Authentication {
    public static final Authentication ANONYMOUS = (name, pswd) -> Optional.of(new User("anonymous"));

    public Optional<User> user(String var1, String var2);

    public static final class Joined
    implements Authentication {
        private final List<Authentication> origins;

        public Joined(Authentication ... origins) {
            this(Arrays.asList(origins));
        }

        public Joined(List<Authentication> origins) {
            this.origins = origins;
        }

        @Override
        public Optional<User> user(String user, String pass) {
            return this.origins.stream().map(auth -> auth.user(user, pass)).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        }

        public String toString() {
            return String.format("%s([%s])", this.getClass().getSimpleName(), this.origins.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
    }

    public static final class Single
    implements Authentication {
        private final User user;
        private final String password;

        public Single(String user, String password) {
            this(new User(user), password);
        }

        public Single(User user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public Optional<User> user(String name, String pass) {
            return Optional.of(name).filter(item -> item.equals(this.user.uname)).filter(ignored -> this.password.equals(pass)).map(ignored -> this.user);
        }
    }

    public static abstract class Wrap
    implements Authentication {
        private final Authentication auth;

        protected Wrap(Authentication auth) {
            this.auth = auth;
        }

        @Override
        public final Optional<User> user(String username, String password) {
            return this.auth.user(username, password);
        }
    }

    public static final class User {
        private final String uname;
        private final Collection<String> ugroups;

        public User(String name, Collection<String> groups) {
            this.uname = name;
            this.ugroups = groups;
        }

        public User(String name) {
            this(name, Collections.emptyList());
        }

        public String name() {
            return this.uname;
        }

        public Collection<String> groups() {
            return this.ugroups;
        }

        public boolean equals(Object other) {
            boolean res;
            if (this == other) {
                res = true;
            } else if (other == null || this.getClass() != other.getClass()) {
                res = false;
            } else {
                User user = (User)other;
                res = Objects.equals(this.uname, user.uname) && Objects.equals(this.ugroups, user.ugroups);
            }
            return res;
        }

        public int hashCode() {
            return Objects.hash(this.uname, this.ugroups);
        }

        public String toString() {
            return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.uname, this.ugroups);
        }
    }
}

