/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.hm;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.headers.Header;
import com.artipie.http.rs.RsStatus;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.reactivestreams.Publisher;

public final class RsHasHeaders
extends TypeSafeMatcher<Response> {
    private final Matcher<? extends Iterable<? extends Map.Entry<String, String>>> headers;

    @SafeVarargs
    public RsHasHeaders(Map.Entry<String, String> ... headers) {
        this(Arrays.asList(headers));
    }

    public RsHasHeaders(Iterable<? extends Map.Entry<String, String>> headers) {
        this((Matcher<? extends Iterable<? extends Map.Entry<String, String>>>)RsHasHeaders.transform(headers));
    }

    @SafeVarargs
    public RsHasHeaders(Matcher<? super Map.Entry<String, String>> ... headers) {
        this((Matcher<? extends Iterable<? extends Map.Entry<String, String>>>)Matchers.hasItems(headers));
    }

    public RsHasHeaders(Matcher<? extends Iterable<? extends Map.Entry<String, String>>> headers) {
        this.headers = headers;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.headers);
    }

    public boolean matchesSafely(Response item) {
        AtomicReference<Iterable<Map.Entry<String, String>>> out = new AtomicReference<Iterable<Map.Entry<String, String>>>();
        item.send(new FakeConnection(out)).toCompletableFuture().join();
        return this.headers.matches(out.get());
    }

    public void describeMismatchSafely(Response item, Description desc) {
        AtomicReference<Iterable<Map.Entry<String, String>>> out = new AtomicReference<Iterable<Map.Entry<String, String>>>();
        item.send(new FakeConnection(out)).toCompletableFuture().join();
        desc.appendText("was ").appendValue((Object)StreamSupport.stream(out.get().spliterator(), false).map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(";")));
    }

    private static Matcher<? extends Iterable<Map.Entry<String, String>>> transform(Iterable<? extends Map.Entry<String, String>> headers) {
        return Matchers.allOf((Iterable)StreamSupport.stream(headers.spliterator(), false).map(original -> new Header((String)original.getKey(), (String)original.getValue())).map(Matchers::hasItem).collect(Collectors.toList()));
    }

    private static final class FakeConnection
    implements Connection {
        private final AtomicReference<Iterable<Map.Entry<String, String>>> container;

        FakeConnection(AtomicReference<Iterable<Map.Entry<String, String>>> container) {
            this.container = container;
        }

        public CompletableFuture<Void> accept(RsStatus status, Headers headers, Publisher<ByteBuffer> body) {
            return CompletableFuture.supplyAsync(() -> {
                this.container.set(ImmutableList.copyOf((Iterable)headers).stream().map(original -> new Header((String)original.getKey(), (String)original.getValue())).collect(Collectors.toList()));
                return null;
            });
        }
    }
}

