/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.misc;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BufAccumulator
implements ReadableByteChannel,
WritableByteChannel {
    private ByteBuffer buffer;

    public BufAccumulator(int cap) {
        this.buffer = BufAccumulator.newEmptyBuffer(cap);
    }

    public boolean empty() {
        return this.buffer.position() == 0;
    }

    public ByteBuffer copyRange(int pos, int lim) {
        ByteBuffer src = this.duplicate();
        src.limit(lim);
        src.position(pos);
        ByteBuffer slice = src.slice();
        ByteBuffer res = ByteBuffer.allocate(slice.remaining());
        res.put(slice);
        res.flip();
        return res.asReadOnlyBuffer();
    }

    public void drop(int size) {
        this.buffer.position(size);
        this.buffer.compact();
        this.buffer.limit(this.buffer.position());
    }

    public ByteBuffer duplicate() {
        this.check();
        return this.buffer.duplicate();
    }

    @Override
    public int read(ByteBuffer dst) {
        this.check();
        int res = -1;
        if (this.buffer.position() > 0) {
            ByteBuffer src = this.buffer.duplicate();
            src.rewind();
            int rem = Math.min(src.remaining(), dst.remaining());
            src.limit(rem);
            dst.put(src);
            this.buffer.position(rem);
            this.buffer.compact();
            this.buffer.limit(this.buffer.position());
            res = rem;
        }
        return res;
    }

    @Override
    public int write(ByteBuffer src) {
        this.check();
        int size = src.remaining();
        if (this.buffer.capacity() - this.buffer.limit() >= size) {
            this.buffer.limit(this.buffer.limit() + src.remaining());
            this.buffer.put(src);
        } else {
            int cap = Math.max(this.buffer.capacity(), src.capacity()) * 2;
            ByteBuffer resized = ByteBuffer.allocate(cap);
            int pos = this.buffer.position();
            int lim = this.buffer.limit();
            this.buffer.flip();
            resized.put(this.buffer);
            resized.limit(lim + size);
            resized.position(pos);
            resized.put(src);
            this.buffer = resized;
        }
        return size;
    }

    public int size() {
        return this.buffer.position();
    }

    public byte[] array() {
        ByteBuffer dup = this.duplicate();
        dup.rewind();
        byte[] res = new byte[dup.remaining()];
        dup.get(res);
        return res;
    }

    @Override
    public void close() {
        this.check();
        this.buffer = null;
    }

    @Override
    public boolean isOpen() {
        return this.buffer != null;
    }

    private void check() {
        assert (this.buffer != null) : "tokenizer was closed";
    }

    private static ByteBuffer newEmptyBuffer(int cap) {
        ByteBuffer buf = ByteBuffer.allocate(cap);
        buf.flip();
        return buf;
    }
}

