/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq.multipart;

import com.artipie.http.ArtipieHttpException;
import com.artipie.http.Headers;
import com.artipie.http.headers.ContentType;
import com.artipie.http.rq.multipart.EmptyPart;
import com.artipie.http.rq.multipart.MultiParts;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import wtf.g4s8.mime.MimeType;

public final class RqMultipart {
    private ContentType ctype;
    private Publisher<ByteBuffer> upstream;

    public RqMultipart(Headers headers, Publisher<ByteBuffer> body) {
        this(new ContentType(headers), body);
    }

    public RqMultipart(ContentType ctype, Publisher<ByteBuffer> body) {
        this.ctype = ctype;
        this.upstream = body;
    }

    public Publisher<Part> parts() {
        MultiParts pub = new MultiParts(this.boundary());
        pub.subscribeAsync(this.upstream);
        return pub;
    }

    public Publisher<? extends Part> inspect(Inspector inspector) {
        return Flowable.fromPublisher(this.parts()).flatMapSingle(part -> {
            InternalSink sink = new InternalSink();
            return Completable.fromFuture(inspector.inspect((Part)part, sink).toCompletableFuture()).andThen(sink.filter());
        }).filter(part -> part != Part.EMPTY);
    }

    @Deprecated
    public Publisher<? extends Part> filter(Predicate<Headers> pred) {
        return this.inspect((part, sink) -> {
            if (pred.test(part.headers())) {
                sink.accept(part);
            } else {
                sink.ignore(part);
            }
            CompletableFuture<Object> res = new CompletableFuture<Object>();
            res.complete(null);
            return res;
        });
    }

    private String boundary() {
        String header = (String)MimeType.of((CharSequence)this.ctype.getValue()).param("boundary").orElseThrow(() -> new ArtipieHttpException(RsStatus.BAD_REQUEST, "Content-type boundary param missed"));
        return String.format("\r\n--%s", header);
    }

    private static final class InternalSink
    implements Sink {
        private Part accepted;
        private Part ignored;

        private InternalSink() {
        }

        @Override
        public void accept(Part part) {
            this.check();
            this.accepted = part;
        }

        @Override
        public void ignore(Part part) {
            this.check();
            this.ignored = part;
        }

        Single<? extends Part> filter() {
            if (this.accepted != null) {
                return Single.just((Object)this.accepted);
            }
            if (this.ignored != null) {
                return Flowable.fromPublisher((Publisher)this.ignored).ignoreElements().toSingleDefault((Object)Part.EMPTY);
            }
            return Single.error(() -> new IllegalStateException("Part should be accepted or ignored explicitly"));
        }

        private void check() {
            if (this.accepted != null) {
                throw new IllegalStateException("Part was accepted already");
            }
            if (this.ignored != null) {
                throw new IllegalStateException("Part was ignored already");
            }
        }
    }

    public static interface Sink {
        public void accept(Part var1);

        public void ignore(Part var1);
    }

    @FunctionalInterface
    public static interface Inspector {
        public CompletionStage<Void> inspect(Part var1, Sink var2);
    }

    public static interface Part
    extends Publisher<ByteBuffer> {
        public static final Part EMPTY = new EmptyPart((Publisher<ByteBuffer>)Flowable.never());

        public Headers headers();
    }
}

