/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq.multipart;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;

final class State {
    private static final int INIT = 1;
    private static final int PREAMBLE = 2;
    private static final int PART = 4;
    private static final int END = 8;
    private static final int START = 16;
    private static final int EPILOGUE = 32;
    private static final Collection<BiFunction<ByteBuffer, Boolean, Patch>> PATCHERS = Collections.unmodifiableList(Arrays.asList((buf, end) -> Patch.equal(1).addFlags(2), (buf, end) -> Patch.hasFlag(1).removeFlags(1), (buf, end) -> Patch.hasFlag(16).removeFlags(16), (buf, end) -> Patch.equal(1).addFlags(16), (buf, end) -> Patch.hasFlag(8).addFlags(16), (buf, end) -> Patch.hasFlag(10).removeFlags(2), (buf, end) -> new Patch(state -> (state & 0x28) == 8, state -> {
        ByteBuffer dup = buf.duplicate();
        int patch = state;
        if (dup.remaining() >= 2 && dup.get() == 45 && dup.get() == 45) {
            patch |= 0x20;
        }
        return patch;
    }), (buf, end) -> new Patch(state -> (state & 8) == 8 != end, state -> {
        int patch = end != false ? state | 8 : state & 0xFFFFFFF7;
        return patch;
    }), (buf, end) -> new Patch(state -> (state & 0x22) == 0).addFlags(4), (buf, end) -> new Patch(state -> (state & 0x22) != 0).removeFlags(4)));
    private volatile int flags = 1;

    State() {
    }

    public String toString() {
        StringBuilder res = new StringBuilder(38);
        if (this.hasFlag(1)) {
            res.append("INIT,");
        }
        if (this.hasFlag(2)) {
            res.append("PREAMBLE,");
        }
        if (this.hasFlag(4)) {
            res.append("PART,");
        }
        if (this.hasFlag(8)) {
            res.append("END,");
        }
        if (this.hasFlag(16)) {
            res.append("START,");
        }
        if (this.hasFlag(32)) {
            res.append("EPILOGUE,");
        }
        return res.toString();
    }

    void patch(ByteBuffer buf, boolean end) {
        for (BiFunction<ByteBuffer, Boolean, Patch> patcher : PATCHERS) {
            ByteBuffer copy;
            Patch patch = patcher.apply(copy = buf.duplicate(), end);
            if (!patch.test(this.flags)) continue;
            this.flags = patch.applyAsInt(this.flags);
        }
    }

    boolean shouldIgnore() {
        return (this.flags & 0x22) != 0;
    }

    boolean isInit() {
        return this.hasFlag(1);
    }

    boolean started() {
        return this.hasFlag(16);
    }

    boolean ended() {
        return this.hasFlag(8);
    }

    private boolean hasFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    private static final class Patch
    implements IntPredicate,
    IntUnaryOperator {
        static final Patch ANY = new Patch(state -> true);
        private final IntPredicate predicate;
        private final IntUnaryOperator operator;

        Patch(IntPredicate predicate) {
            this(predicate, state -> state);
        }

        Patch(IntPredicate predicate, IntUnaryOperator operator) {
            this.operator = operator;
            this.predicate = predicate;
        }

        @Override
        public boolean test(int state) {
            return this.predicate.test(state);
        }

        @Override
        public int applyAsInt(int state) {
            return this.operator.applyAsInt(state);
        }

        Patch addFlags(int flags) {
            return new Patch(this.predicate, this.operator.andThen(state -> state | flags));
        }

        Patch removeFlags(int flags) {
            return new Patch(this.predicate, this.operator.andThen(state -> state & ~flags));
        }

        static Patch equal(int val) {
            return new Patch(test -> test == val, state -> state);
        }

        static Patch hasFlag(int flag) {
            return new Patch(test -> (test & flag) == flag, state -> state);
        }

        static Patch hasNoFlag(int flag) {
            return new Patch(test -> (test & flag) == 0, state -> state);
        }
    }
}

