/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.amihaiemil.eoyaml.YamlMapping;
import com.artipie.ArtipieException;
import com.artipie.asto.factory.FactoryLoader;
import com.artipie.http.auth.ArtipieAuthFactory;
import com.artipie.http.auth.AuthFactory;
import com.artipie.http.auth.Authentication;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class AuthLoader
extends FactoryLoader<AuthFactory, ArtipieAuthFactory, YamlMapping, Authentication> {
    public static final String SCAN_PACK = "AUTH_FACTORY_SCAN_PACKAGES";

    public AuthLoader(Map<String, String> env) {
        super(ArtipieAuthFactory.class, env);
    }

    public AuthLoader() {
        this(System.getenv());
    }

    public Set<String> defPackages() {
        return Collections.singleton("com.artipie");
    }

    public String scanPackagesEnv() {
        return SCAN_PACK;
    }

    public Authentication newObject(String type, YamlMapping mapping) {
        AuthFactory factory = (AuthFactory)this.factories.get(type);
        if (factory == null) {
            throw new ArtipieException(String.format("Auth type %s is not found", type));
        }
        return factory.getAuthentication(mapping);
    }

    public String getFactoryName(Class<?> clazz) {
        return Arrays.stream(clazz.getAnnotations()).filter(ArtipieAuthFactory.class::isInstance).map(inst -> ((ArtipieAuthFactory)inst).value()).findFirst().orElseThrow(() -> new ArtipieException("Annotation 'ArtipieAuthFactory' should have a not empty value"));
    }
}

