/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.AuthUser;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface AuthScheme {
    public static final AuthScheme NONE = (hdrs, line) -> CompletableFuture.completedFuture(new Result(){

        @Override
        public Optional<AuthUser> user() {
            return Optional.of(new AuthUser("anonymous", "unknown"));
        }

        @Override
        public String challenge() {
            throw new UnsupportedOperationException();
        }
    });

    public CompletionStage<Result> authenticate(Iterable<Map.Entry<String, String>> var1, String var2);

    default public CompletionStage<Result> authenticate(Iterable<Map.Entry<String, String>> headers) {
        return this.authenticate(headers, "");
    }

    public static final class Fake
    implements AuthScheme {
        public static final String FAKE_CHLLNG = "fake";
        private final Optional<AuthUser> usr;
        private final String chllng;

        public Fake(Optional<AuthUser> usr, String chllng) {
            this.usr = usr;
            this.chllng = chllng;
        }

        public Fake(String name) {
            this(Optional.of(new AuthUser(name)), FAKE_CHLLNG);
        }

        public Fake() {
            this(Optional.empty(), FAKE_CHLLNG);
        }

        @Override
        public CompletionStage<Result> authenticate(Iterable<Map.Entry<String, String>> headers, String line) {
            return CompletableFuture.completedFuture(new Result(){

                @Override
                public Optional<AuthUser> user() {
                    return usr;
                }

                @Override
                public String challenge() {
                    return chllng;
                }
            });
        }
    }

    public static interface Result {
        public Optional<AuthUser> user();

        public String challenge();
    }
}

