/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.AuthUser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Authentication {
    public static final Authentication ANONYMOUS = (name, pswd) -> Optional.of(new AuthUser("anonymous", "unknown"));
    public static final AuthUser ANY_USER = new AuthUser("*", "any");

    public Optional<AuthUser> user(String var1, String var2);

    public static final class Joined
    implements Authentication {
        private final List<Authentication> origins;

        public Joined(Authentication ... origins) {
            this(Arrays.asList(origins));
        }

        public Joined(List<Authentication> origins) {
            this.origins = origins;
        }

        @Override
        public Optional<AuthUser> user(String user, String pass) {
            return this.origins.stream().map(auth -> auth.user(user, pass)).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        }

        public String toString() {
            return String.format("%s([%s])", this.getClass().getSimpleName(), this.origins.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
    }

    public static final class Single
    implements Authentication {
        private final AuthUser user;
        private final String password;

        public Single(String user, String password) {
            this(new AuthUser(user, "single"), password);
        }

        public Single(AuthUser user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public Optional<AuthUser> user(String name, String pass) {
            return Optional.of(name).filter(item -> item.equals(this.user.name())).filter(ignored -> this.password.equals(pass)).map(ignored -> this.user);
        }
    }

    public static abstract class Wrap
    implements Authentication {
        private final Authentication auth;

        protected Wrap(Authentication auth) {
            this.auth = auth;
        }

        @Override
        public final Optional<AuthUser> user(String username, String password) {
            return this.auth.user(username, password);
        }
    }
}

