/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.AuthUser;
import com.artipie.http.auth.Authentication;
import com.artipie.http.headers.Authorization;
import com.artipie.http.rq.RqHeaders;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class BasicAuthScheme
implements AuthScheme {
    public static final String NAME = "Basic";
    private static final String CHALLENGE = String.format("%s realm=\"artipie\"", "Basic");
    private final Authentication auth;

    public BasicAuthScheme(Authentication auth) {
        this.auth = auth;
    }

    @Override
    public CompletionStage<AuthScheme.Result> authenticate(Iterable<Map.Entry<String, String>> headers, String line) {
        return CompletableFuture.completedFuture(this.user(headers).map(Success::new).orElseGet(() -> new Failure()));
    }

    private Optional<AuthUser> user(Iterable<Map.Entry<String, String>> headers) {
        return new RqHeaders(headers, "Authorization").stream().findFirst().map(Authorization::new).filter(hdr -> hdr.scheme().equals(NAME)).map(hdr -> new Authorization.Basic(hdr.credentials())).flatMap(hdr -> this.auth.user(hdr.username(), hdr.password()));
    }

    private static class Failure
    implements AuthScheme.Result {
        private Failure() {
        }

        @Override
        public Optional<AuthUser> user() {
            return Optional.empty();
        }

        @Override
        public String challenge() {
            return CHALLENGE;
        }
    }

    private static class Success
    implements AuthScheme.Result {
        private final AuthUser usr;

        Success(AuthUser user) {
            this.usr = user;
        }

        @Override
        public Optional<AuthUser> user() {
            return Optional.of(this.usr);
        }

        @Override
        public String challenge() {
            return CHALLENGE;
        }
    }
}

