/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.filter;

import com.amihaiemil.eoyaml.YamlMapping;
import com.artipie.ArtipieException;
import com.artipie.asto.factory.FactoryLoader;
import com.artipie.http.filter.ArtipieFilterFactory;
import com.artipie.http.filter.Filter;
import com.artipie.http.filter.FilterFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FilterFactoryLoader
extends FactoryLoader<FilterFactory, ArtipieFilterFactory, YamlMapping, Filter> {
    public static final String SCAN_PACK = "FILTER_FACTORY_SCAN_PACKAGES";

    public FilterFactoryLoader() {
        this(System.getenv());
    }

    public FilterFactoryLoader(Map<String, String> env) {
        super(ArtipieFilterFactory.class, env);
    }

    public Set<String> defPackages() {
        return Stream.of("com.artipie.http.filter").collect(Collectors.toSet());
    }

    public String scanPackagesEnv() {
        return SCAN_PACK;
    }

    public Filter newObject(String type, YamlMapping yaml) {
        FilterFactory factory = (FilterFactory)this.factories.get(type);
        if (factory == null) {
            throw new ArtipieException(String.format("%s type %s is not found", Filter.class.getSimpleName(), type));
        }
        return factory.newFilter(yaml);
    }

    public String getFactoryName(Class<?> clazz) {
        return Arrays.stream(clazz.getAnnotations()).filter(ArtipieFilterFactory.class::isInstance).map(inst -> ((ArtipieFilterFactory)inst).value()).findFirst().orElseThrow(() -> new ArtipieException(String.format("Annotation '%s' should have a not empty value", ArtipieFilterFactory.class.getSimpleName())));
    }
}

