/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.filter;

import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import com.artipie.http.filter.Filter;
import com.artipie.http.filter.FilterFactoryLoader;
import com.artipie.http.rq.RequestLineFrom;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Filters {
    private static final FilterFactoryLoader FILTER_LOADER = new FilterFactoryLoader();
    private final List<Filter> includes;
    private final List<Filter> excludes;

    public Filters(YamlMapping yaml) {
        this.includes = Filters.readFilterList(yaml, "include");
        this.excludes = Filters.readFilterList(yaml, "exclude");
    }

    public boolean allowed(String line, Iterable<Map.Entry<String, String>> headers) {
        RequestLineFrom rqline = new RequestLineFrom(line);
        boolean included = this.includes.stream().anyMatch(filter -> filter.check(rqline, headers));
        boolean excluded = this.excludes.stream().anyMatch(filter -> filter.check(rqline, headers));
        return included & !excluded;
    }

    public int size() {
        return this.includes.size() + this.excludes.size();
    }

    private static List<Filter> readFilterList(YamlMapping yaml, String property) {
        List<Filter> list = Optional.ofNullable(yaml.yamlMapping(property)).map(map -> map.keys().stream().map(key -> key.asScalar().value()).map(type -> map.yamlSequence(type).values().stream().map(YamlNode::asMapping).map(node -> FILTER_LOADER.newObject((String)type, (YamlMapping)node)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
        list.sort(Collections.reverseOrder(Comparator.comparingInt(Filter::priority)));
        return list;
    }
}

