/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class RqHeaders
extends AbstractList<String> {
    private final List<String> origin;

    public RqHeaders(Iterable<Map.Entry<String, String>> headers, String name) {
        this.origin = StreamSupport.stream(headers.spliterator(), false).filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(name)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public String get(int idx) {
        return this.origin.get(idx);
    }

    @Override
    public int size() {
        return this.origin.size();
    }

    public static final class Single {
        private final List<String> headers;

        public Single(Iterable<Map.Entry<String, String>> headers, String name) {
            this.headers = new RqHeaders(headers, name);
        }

        public String asString() {
            if (this.headers.isEmpty()) {
                throw new IllegalStateException("No headers were found");
            }
            if (this.headers.size() > 1) {
                throw new IllegalStateException("Too many headers were found");
            }
            return this.headers.get(0);
        }
    }
}

