/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentType;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.http.slice.ListingFormat;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class SliceListing
implements Slice {
    private final Storage storage;
    private final Function<String, Key> transform;
    private final String mtype;
    private final ListingFormat format;

    public SliceListing(Storage storage, String mtype, ListingFormat format) {
        this(storage, KeyFromPath::new, mtype, format);
    }

    public SliceListing(Storage storage, Function<String, Key> transform, String mtype, ListingFormat format) {
        this.storage = storage;
        this.transform = transform;
        this.mtype = mtype;
        this.format = format;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(CompletableFuture.supplyAsync(new RequestLineFrom(line)::uri).thenCompose(uri -> {
            Key key = this.transform.apply(uri.getPath());
            return this.storage.list(key).thenApply(keys -> {
                String text = this.format.apply((Collection<? extends Key>)keys);
                return new RsFull(RsStatus.OK, (Iterable<Map.Entry<String, String>>)new Headers.From((Map.Entry<String, String>)new ContentType(String.format("%s; charset=%s", this.mtype, StandardCharsets.UTF_8))), (Content)new Content.From(text.getBytes(StandardCharsets.UTF_8)));
            });
        }));
    }
}

