/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.security.perms;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Action {
    public static final Action ALL = new All();
    public static final Action NONE = new Action(){

        @Override
        public Set<String> names() {
            return Collections.emptySet();
        }

        @Override
        public int mask() {
            return 0;
        }
    };

    public Set<String> names();

    public int mask();

    public static final class All
    implements Action {
        private final int mask = All.calcMask();

        private All() {
        }

        @Override
        public Set<String> names() {
            return Collections.singleton("*");
        }

        @Override
        public int mask() {
            return this.mask;
        }

        private static int calcMask() {
            AtomicInteger res = new AtomicInteger();
            Arrays.stream(Standard.values()).map(Action::mask).forEach(val -> res.updateAndGet(v -> v | val));
            return res.get();
        }
    }

    public static enum Standard implements Action
    {
        READ(4, "read", "r", "download", "install", "pull"),
        WRITE(2, "write", "w", "publish", "push", "deploy", "upload"),
        DELETE(8, "delete", "d", "remove");

        private final Set<String> synonyms;
        private final int val;

        private Standard(int value, String ... names) {
            this(Stream.of(names).collect(Collectors.toSet()), value);
        }

        private Standard(Set<String> names, int value) {
            this.synonyms = names;
            this.val = value;
        }

        @Override
        public Set<String> names() {
            return this.synonyms;
        }

        @Override
        public int mask() {
            return this.val;
        }

        static int maskByAction(String name) {
            for (Standard item : Standard.values()) {
                if (!item.names().contains(name)) continue;
                return item.mask();
            }
            throw new IllegalArgumentException(String.format("Unknown permission action %s", name));
        }
    }
}

