/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.security.perms;

import com.artipie.security.perms.Action;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AdapterBasicPermission
extends Permission {
    static final String WILDCARD = "*";
    private static final long serialVersionUID = -2916496571451236071L;
    private String actions;
    private final transient int mask;

    private AdapterBasicPermission(String name, int mask) {
        super(name);
        this.mask = mask;
    }

    public AdapterBasicPermission(String repo, String strings) {
        this(repo, Stream.of(strings.split(",")).collect(Collectors.toSet()));
    }

    public AdapterBasicPermission(String repo, Action action) {
        this(repo, action.mask());
    }

    public AdapterBasicPermission(String repo, Collection<String> strings) {
        this(repo, AdapterBasicPermission.maskFromActions(strings));
    }

    @Override
    public boolean implies(Permission permission) {
        boolean res;
        if (permission instanceof AdapterBasicPermission) {
            AdapterBasicPermission that = (AdapterBasicPermission)permission;
            res = (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
        } else {
            res = false;
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        boolean res;
        if (obj == this) {
            res = true;
        } else if (obj instanceof AdapterBasicPermission) {
            AdapterBasicPermission that = (AdapterBasicPermission)obj;
            res = that.mask == this.mask && Objects.equals(that.getName(), this.getName());
        } else {
            res = false;
        }
        return res;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            StringJoiner joiner = new StringJoiner(",");
            if ((this.mask & Action.Standard.READ.mask()) == Action.Standard.READ.mask()) {
                joiner.add(Action.Standard.READ.name().toLowerCase(Locale.ROOT));
            }
            if ((this.mask & Action.Standard.WRITE.mask()) == Action.Standard.WRITE.mask()) {
                joiner.add(Action.Standard.WRITE.name().toLowerCase(Locale.ROOT));
            }
            if ((this.mask & Action.Standard.DELETE.mask()) == Action.Standard.DELETE.mask()) {
                joiner.add(Action.Standard.DELETE.name().toLowerCase(Locale.ROOT));
            }
            this.actions = joiner.toString();
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new AdapterBasicPermissionCollection();
    }

    private boolean impliesIgnoreMask(AdapterBasicPermission perm) {
        boolean res = this.getName().equals(WILDCARD) ? true : this.getName().equalsIgnoreCase(perm.getName());
        return res;
    }

    private static int maskFromActions(Collection<String> actions) {
        int res = Action.NONE.mask();
        if (actions.isEmpty() || actions.size() == 1 && actions.contains("")) {
            res = Action.NONE.mask();
        } else if (actions.contains(WILDCARD)) {
            res = Action.ALL.mask();
        } else {
            for (String item : actions) {
                res |= Action.Standard.maskByAction(item);
            }
        }
        return res;
    }

    static final class AdapterBasicPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private static final long serialVersionUID = 5843017424729092155L;
        private final transient ConcurrentHashMap<String, Permission> perms = new ConcurrentHashMap(5);
        private boolean any = false;

        AdapterBasicPermissionCollection() {
        }

        @Override
        public void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            if (permission instanceof AdapterBasicPermission) {
                this.perms.put(permission.getName(), permission);
                if (permission.getName().equals(AdapterBasicPermission.WILDCARD) && ((AdapterBasicPermission)permission).mask == Action.ALL.mask()) {
                    this.any = true;
                }
            } else {
                throw new IllegalArgumentException(String.format("Invalid permissions type %s", permission.getClass()));
            }
        }

        @Override
        public boolean implies(Permission permission) {
            boolean res = false;
            if (permission instanceof AdapterBasicPermission) {
                if (this.any) {
                    res = true;
                } else {
                    Permission existing = this.perms.get(permission.getName());
                    if (existing != null) {
                        res = existing.implies(permission);
                    }
                    if (!res && (existing = this.perms.get(AdapterBasicPermission.WILDCARD)) != null) {
                        res = existing.implies(permission);
                    }
                }
            }
            return res;
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.perms.elements();
        }
    }
}

