/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.security.perms;

import com.amihaiemil.eoyaml.Node;
import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import com.amihaiemil.eoyaml.YamlSequence;
import com.artipie.asto.factory.Config;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public interface PermissionConfig
extends Config {
    public Set<String> keys();

    public static final class FromYamlSequence
    implements PermissionConfig {
        private final YamlSequence seq;

        public FromYamlSequence(YamlSequence seq) {
            this.seq = seq;
        }

        @Override
        public Set<String> keys() {
            return this.seq.values().stream().map(YamlNode::asScalar).map(Scalar::value).collect(Collectors.toSet());
        }

        public String string(String index) {
            return this.seq.string(Integer.parseInt(index));
        }

        public Collection<String> sequence(String index) {
            return this.seq.yamlSequence(Integer.parseInt(index)).values().stream().map(YamlNode::asScalar).map(Scalar::value).collect(Collectors.toSet());
        }

        public PermissionConfig config(String index) {
            PermissionConfig res;
            int ind = Integer.parseInt(index);
            if (this.seq.yamlSequence(ind) != null) {
                res = new FromYamlSequence(this.seq.yamlSequence(ind));
            } else if (this.seq.yamlMapping(ind) != null) {
                res = new FromYamlMapping(this.seq.yamlMapping(ind));
            } else {
                throw new IllegalArgumentException(String.format("Sub config by index %s not found", index));
            }
            return res;
        }

        public boolean isEmpty() {
            return this.seq == null || this.seq.isEmpty();
        }
    }

    public static final class FromYamlMapping
    implements PermissionConfig {
        private final YamlMapping yaml;

        public FromYamlMapping(YamlMapping yaml) {
            this.yaml = yaml;
        }

        public String string(String key) {
            return this.yaml.string(key);
        }

        public Set<String> sequence(String key) {
            Set<String> res = "*".equals(key) ? this.yaml.yamlSequence((YamlNode)this.getWildcardKey(key)).values().stream().map(item -> item.asScalar().value()).collect(Collectors.toSet()) : this.yaml.yamlSequence(key).values().stream().map(item -> item.asScalar().value()).collect(Collectors.toSet());
            return res;
        }

        @Override
        public Set<String> keys() {
            return this.yaml.keys().stream().map(node -> node.asScalar().value()).map(FromYamlMapping::cleanName).collect(Collectors.toSet());
        }

        public PermissionConfig config(String key) {
            PermissionConfig res = "*".equals(key) ? FromYamlMapping.configByNode(this.yaml.value((YamlNode)this.getWildcardKey(key))) : FromYamlMapping.configByNode(this.yaml.value(key));
            return res;
        }

        public boolean isEmpty() {
            return this.yaml == null || this.yaml.isEmpty();
        }

        private Scalar getWildcardKey(String key) {
            return this.yaml.keys().stream().map(YamlNode::asScalar).filter(item -> item.value().contains("*")).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Sequence %s not found", key)));
        }

        private static String cleanName(String value) {
            String res = value;
            if (value.contains("*")) {
                res = value.replace("\"", "").replace("'", "").replace("\\", "");
            }
            return res;
        }

        private static PermissionConfig configByNode(YamlNode node) {
            PermissionConfig res;
            if (node.type() == Node.MAPPING) {
                res = new FromYamlMapping(node.asMapping());
            } else if (node.type() == Node.SEQUENCE) {
                res = new FromYamlSequence(node.asSequence());
            } else {
                throw new IllegalArgumentException("Yaml sub-config not found!");
            }
            return res;
        }
    }
}

