/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.security.perms;

import com.artipie.ArtipieException;
import com.artipie.asto.factory.FactoryLoader;
import com.artipie.security.perms.ArtipiePermissionFactory;
import com.artipie.security.perms.PermissionConfig;
import com.artipie.security.perms.PermissionFactory;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class PermissionsLoader
extends FactoryLoader<PermissionFactory<PermissionCollection>, ArtipiePermissionFactory, PermissionConfig, PermissionCollection> {
    public static final String SCAN_PACK = "PERM_FACTORY_SCAN_PACKAGES";

    public PermissionsLoader() {
        this(System.getenv());
    }

    public PermissionsLoader(Map<String, String> env) {
        super(ArtipiePermissionFactory.class, env);
    }

    public Set<String> defPackages() {
        return Stream.of("com.artipie.security", "com.artipie.docker", "com.artipie.api.perms").collect(Collectors.toSet());
    }

    public String scanPackagesEnv() {
        return SCAN_PACK;
    }

    public PermissionCollection newObject(String type, PermissionConfig config) {
        PermissionFactory factory = (PermissionFactory)this.factories.get(type);
        if (factory == null) {
            throw new ArtipieException(String.format("Permission type %s is not found", type));
        }
        return factory.newPermissions(config);
    }

    public String getFactoryName(Class<?> clazz) {
        return Arrays.stream(clazz.getAnnotations()).filter(ArtipiePermissionFactory.class::isInstance).map(inst -> ((ArtipiePermissionFactory)inst).value()).findFirst().orElseThrow(() -> new ArtipieException("Annotation 'ArtipiePermissionFactory' should have a not empty value"));
    }
}

