/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.security.perms;

import com.artipie.security.perms.User;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

public final class UserPermissions
extends PermissionCollection {
    private static final long serialVersionUID = -7546496571951236695L;
    private final Object lock;
    private final Function<String, PermissionCollection> rperms;
    private final Supplier<User> user;
    private final AtomicReference<String> last;

    public UserPermissions(Supplier<User> user, Function<String, PermissionCollection> rperms) {
        this.rperms = rperms;
        this.user = user;
        this.last = new AtomicReference();
        this.lock = new Object();
    }

    @Override
    public void add(Permission permission) {
        this.user.get().perms().add(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        String first = this.last.get();
        boolean res = this.checkReference(first, permission);
        if (!res) {
            Object object = this.lock;
            synchronized (object) {
                String second = this.last.get();
                if (!Objects.equals(first, second)) {
                    res = this.checkReference(second, permission);
                }
                if (!res) {
                    if (second != null) {
                        res = this.user.get().perms().implies(permission);
                    }
                    if (res) {
                        this.last.set(null);
                    } else {
                        for (String role : this.user.get().roles()) {
                            if (role.equals(second) || !this.rperms.apply(role).implies(permission)) continue;
                            res = true;
                            this.last.set(role);
                            break;
                        }
                    }
                }
            }
        }
        return res;
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.user.get().perms().elements();
    }

    private boolean checkReference(String ref, Permission permission) {
        boolean res = ref == null ? this.user.get().perms().implies(permission) : this.rperms.apply(ref).implies(permission);
        return res;
    }
}

