/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.security.policy;

import com.amihaiemil.eoyaml.Node;
import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import com.amihaiemil.eoyaml.YamlSequence;
import com.artipie.ArtipieException;
import com.artipie.asto.Key;
import com.artipie.asto.ValueNotFoundException;
import com.artipie.asto.blocking.BlockingStorage;
import com.artipie.asto.misc.Cleanable;
import com.artipie.asto.misc.UncheckedFunc;
import com.artipie.asto.misc.UncheckedSupplier;
import com.artipie.http.auth.AuthUser;
import com.artipie.http.auth.Authentication;
import com.artipie.security.perms.EmptyPermissions;
import com.artipie.security.perms.PermissionConfig;
import com.artipie.security.perms.PermissionsLoader;
import com.artipie.security.perms.User;
import com.artipie.security.perms.UserPermissions;
import com.artipie.security.policy.Policy;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jcabi.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class CachedYamlPolicy
implements Policy<UserPermissions>,
Cleanable<String> {
    private static final PermissionsLoader FACTORIES = new PermissionsLoader();
    private static final PermissionConfig EMPTY_CONFIG = new PermissionConfig.FromYamlMapping(Yaml.createYamlMappingBuilder().build());
    private static final UserPermissions EMPTY_PERMS = new UserPermissions(() -> User.EMPTY, role -> EmptyPermissions.INSTANCE);
    private final Cache<String, UserPermissions> cache;
    private final Cache<String, User> users;
    private final Cache<String, PermissionCollection> roles;
    private final BlockingStorage asto;

    CachedYamlPolicy(Cache<String, UserPermissions> cache, Cache<String, User> users, Cache<String, PermissionCollection> roles, BlockingStorage asto) {
        this.cache = cache;
        this.users = users;
        this.roles = roles;
        this.asto = asto;
    }

    public CachedYamlPolicy(BlockingStorage asto, long eviction) {
        this((Cache<String, UserPermissions>)CacheBuilder.newBuilder().expireAfterAccess(eviction, TimeUnit.MILLISECONDS).build(), (Cache<String, User>)CacheBuilder.newBuilder().expireAfterAccess(eviction, TimeUnit.MILLISECONDS).build(), (Cache<String, PermissionCollection>)CacheBuilder.newBuilder().expireAfterAccess(eviction, TimeUnit.MILLISECONDS).build(), asto);
    }

    @Override
    public UserPermissions getPermissions(AuthUser user) {
        UserPermissions res;
        if (Authentication.ANY_USER.name().equals(user.name())) {
            res = EMPTY_PERMS;
        } else {
            try {
                res = (UserPermissions)this.cache.get((Object)user.name(), this.createUserPermissions(user));
            }
            catch (ExecutionException err) {
                Logger.error((Object)this, (String)err.getMessage());
                throw new ArtipieException((Throwable)err);
            }
        }
        return res;
    }

    public void invalidate(String key) {
        if (this.cache.asMap().containsKey(key)) {
            this.cache.invalidate((Object)key);
            this.users.invalidate((Object)key);
        } else if (this.roles.asMap().containsKey(key)) {
            this.roles.invalidate((Object)key);
        }
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
        this.users.invalidateAll();
        this.roles.invalidateAll();
    }

    static PermissionCollection rolePermissions(BlockingStorage asto, String role) {
        PermissionCollection res;
        String filename = String.format("roles/%s", role);
        try {
            YamlMapping mapping = CachedYamlPolicy.readFile(asto, filename);
            String enabled = mapping.string("enabled");
            res = Boolean.FALSE.toString().equalsIgnoreCase(enabled) ? EmptyPermissions.INSTANCE : CachedYamlPolicy.readPermissionsFromYaml(mapping);
        }
        catch (ValueNotFoundException | IOException err) {
            Logger.error((Object)err, (String)String.format("Failed to read/parse file '%s'", filename));
            res = EmptyPermissions.INSTANCE;
        }
        return res;
    }

    private Callable<UserPermissions> createUserPermissions(AuthUser user) {
        return () -> new UserPermissions((Supplier<User>)new UncheckedSupplier(() -> (User)this.users.get((Object)user.name(), () -> new AstoUser(this.asto, user))), (Function<String, PermissionCollection>)new UncheckedFunc(role -> (PermissionCollection)this.roles.get(role, () -> CachedYamlPolicy.rolePermissions(this.asto, role))));
    }

    private static YamlMapping readFile(BlockingStorage asto, String filename) throws IOException {
        byte[] res;
        Key.From yaml = new Key.From(String.format("%s.yaml", filename));
        Key.From yml = new Key.From(String.format("%s.yml", filename));
        if (asto.exists((Key)yaml)) {
            res = asto.value((Key)yaml);
        } else if (asto.exists((Key)yml)) {
            res = asto.value((Key)yml);
        } else {
            throw new ValueNotFoundException((Key)yaml);
        }
        return Yaml.createYamlInput((InputStream)new ByteArrayInputStream(res)).readYamlMapping();
    }

    private static PermissionCollection readPermissionsFromYaml(YamlMapping mapping) {
        PermissionCollection res;
        YamlMapping all = mapping.yamlMapping("permissions");
        if (all == null || all.keys().isEmpty()) {
            res = EmptyPermissions.INSTANCE;
        } else {
            res = new Permissions();
            for (String type : all.keys().stream().map(item -> item.asScalar().value()).collect(Collectors.toSet())) {
                YamlNode perms = all.value(type);
                PermissionConfig config = perms != null && perms.type() == Node.MAPPING ? new PermissionConfig.FromYamlMapping(perms.asMapping()) : (perms != null && perms.type() == Node.SEQUENCE ? new PermissionConfig.FromYamlSequence(perms.asSequence()) : EMPTY_CONFIG);
                Collections.list(FACTORIES.newObject(type, config).elements()).forEach(res::add);
            }
        }
        return res;
    }

    public static final class AstoUser
    implements User {
        private static final String ENABLED = "enabled";
        private static final String FORMAT = "users/%s";
        private final PermissionCollection perms;
        private final Collection<String> roles;

        AstoUser(BlockingStorage asto, AuthUser user) {
            YamlMapping yaml = AstoUser.getYamlMapping(asto, user.name());
            this.perms = AstoUser.perms(yaml);
            this.roles = AstoUser.roles(yaml, user);
        }

        @Override
        public PermissionCollection perms() {
            return this.perms;
        }

        @Override
        public Collection<String> roles() {
            return this.roles;
        }

        private static PermissionCollection perms(YamlMapping yaml) {
            PermissionCollection res = AstoUser.disabled(yaml) ? EmptyPermissions.INSTANCE : CachedYamlPolicy.readPermissionsFromYaml(yaml);
            return res;
        }

        private static Collection<String> roles(YamlMapping yaml, AuthUser user) {
            Set<String> roles = Collections.emptySet();
            if (!AstoUser.disabled(yaml)) {
                YamlSequence sequence = yaml.yamlSequence("roles");
                if (sequence != null) {
                    roles = sequence.values().stream().map(item -> item.asScalar().value()).collect(Collectors.toSet());
                }
                if (user.authContext() != null && !user.authContext().isEmpty()) {
                    String role = String.format("default/%s", user.authContext());
                    if (roles.isEmpty()) {
                        roles = Collections.singleton(role);
                    } else {
                        roles.add(role);
                    }
                }
            }
            return roles;
        }

        private static boolean disabled(YamlMapping yaml) {
            return Boolean.FALSE.toString().equalsIgnoreCase(yaml.string(ENABLED));
        }

        private static YamlMapping getYamlMapping(BlockingStorage asto, String username) {
            YamlMapping res;
            String filename = String.format(FORMAT, username);
            try {
                res = CachedYamlPolicy.readFile(asto, filename);
            }
            catch (ValueNotFoundException | IOException err) {
                Logger.error((Object)err, (String)String.format("Failed to read or parse file '%s'", filename));
                res = Yaml.createYamlMappingBuilder().build();
            }
            return res;
        }
    }
}

