/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.security.policy;

import com.artipie.ArtipieException;
import com.artipie.asto.factory.Config;
import com.artipie.asto.factory.FactoryLoader;
import com.artipie.security.policy.ArtipiePolicyFactory;
import com.artipie.security.policy.Policy;
import com.artipie.security.policy.PolicyFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class PoliciesLoader
extends FactoryLoader<PolicyFactory, ArtipiePolicyFactory, Config, Policy<?>> {
    public static final String SCAN_PACK = "POLICY_FACTORY_SCAN_PACKAGES";

    public PoliciesLoader(Map<String, String> env) {
        super(ArtipiePolicyFactory.class, env);
    }

    public PoliciesLoader() {
        this(System.getenv());
    }

    public Set<String> defPackages() {
        return Collections.singleton("com.artipie.security");
    }

    public String scanPackagesEnv() {
        return SCAN_PACK;
    }

    public Policy<?> newObject(String type, Config config) {
        PolicyFactory factory = (PolicyFactory)this.factories.get(type);
        if (factory == null) {
            throw new ArtipieException(String.format("Policy type %s is not found", type));
        }
        return factory.getPolicy(config);
    }

    public String getFactoryName(Class<?> clazz) {
        return Arrays.stream(clazz.getAnnotations()).filter(ArtipiePolicyFactory.class::isInstance).map(inst -> ((ArtipiePolicyFactory)inst).value()).findFirst().orElseThrow(() -> new ArtipieException("Annotation 'ArtipiePolicyFactory' should have a not empty value"));
    }
}

