/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api;

import com.artipie.http.auth.Authentication;
import com.artipie.http.rq.RqHeaders;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.crypto.Cipher;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class Cookies {
    private final Iterable<Map.Entry<String, String>> headers;

    public Cookies(Iterable<Map.Entry<String, String>> headers) {
        this.headers = headers;
    }

    public Optional<Authentication.User> user() {
        return Optional.ofNullable(Cookies.cookies((Iterable<String>)new RqHeaders(this.headers, "Cookie")).get("session")).flatMap(Cookies::session);
    }

    private static Map<String, String> cookies(Iterable<String> raw) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        for (String value : raw) {
            for (String pair : value.split(";")) {
                String[] parts = pair.split("=", 2);
                String key = parts[0].trim().toLowerCase(Locale.US);
                if (parts.length > 1 && !parts[1].isEmpty()) {
                    map.put(key, parts[1].trim());
                    continue;
                }
                map.remove(key);
            }
        }
        return map;
    }

    private static Optional<Authentication.User> session(String encoded) {
        Optional<Authentication.User> user;
        String env = System.getenv("ARTIPIE_SESSION_KEY");
        if (env == null) {
            user = Optional.empty();
        } else {
            try {
                byte[] key = Files.readAllBytes(Paths.get(env, new String[0]));
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
                Cipher rsa = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                rsa.init(2, KeyFactory.getInstance("RSA").generatePrivate(spec));
                user = Optional.of(new Authentication.User(new String(rsa.doFinal(Hex.decodeHex((char[])encoded.toCharArray())), StandardCharsets.UTF_8)));
            }
            catch (IOException | GeneralSecurityException | DecoderException err) {
                Logger.error(Cookies.class, (String)"Failed to read session cookie: %[exception]s");
                throw new IllegalStateException("Failed to read session cookie");
            }
        }
        return user;
    }
}

