/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api;

import com.amihaiemil.eoyaml.YamlNode;
import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.headers.Header;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public final class RsYaml
implements Response {
    private final Supplier<? extends YamlNode> yaml;
    private final Charset encoding;

    public RsYaml(YamlNode yaml) {
        this(() -> yaml);
    }

    public RsYaml(Supplier<? extends YamlNode> yaml) {
        this(yaml, StandardCharsets.UTF_8);
    }

    public RsYaml(Supplier<? extends YamlNode> yaml, Charset encoding) {
        this.yaml = yaml;
        this.encoding = encoding;
    }

    public CompletionStage<Void> send(Connection connection) {
        byte[] bytes = this.yaml.get().toString().getBytes(this.encoding);
        return connection.accept(RsStatus.OK, (Headers)new Headers.From(new Map.Entry[]{new Header("content-type", String.format("text/yaml; charset=%s", this.encoding.displayName())), new Header("content-length", Integer.toString(bytes.length))}), (Publisher)Flowable.just((Object)ByteBuffer.wrap(bytes)));
    }
}

