/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api.artifactory;

import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.management.api.ContentAsJson;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonObject;
import org.reactivestreams.Publisher;

public final class CreateRepoSlice
implements Slice {
    private static final Pattern PTN = Pattern.compile("/api/repositories/(?<first>[^/.]+)(?<second>/[^/.]+)?/?");
    private final Storage storage;

    public CreateRepoSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(((Single)Single.just(body).to((Function)new ContentAsJson())).flatMap(json -> Single.fromFuture((Future)CreateRepoSlice.valid(json).map(name -> {
            Key key = CreateRepoSlice.yamlKey(line, name);
            return this.storage.exists(key).thenCompose(exists -> {
                CompletionStage res = exists != false ? CompletableFuture.completedStage(new RsWithStatus(RsStatus.BAD_REQUEST)) : this.storage.save(key, (Content)new Content.From(CreateRepoSlice.yaml().toString().getBytes(StandardCharsets.UTF_8))).thenApply(ignored -> new RsWithStatus(RsStatus.OK));
                return res;
            });
        }).orElse(CompletableFuture.completedFuture(new RsWithStatus(RsStatus.BAD_REQUEST))))));
    }

    private static Optional<String> valid(JsonObject json) {
        String key = json.getString("key", "");
        Optional<String> res = !key.isEmpty() && "local".equals(json.getString("rclass", "")) && "docker".equals(json.getString("packageType", "")) && "V2".equals(json.getString("dockerApiVersion", "")) ? Optional.of(key) : Optional.empty();
        return res;
    }

    private static Key yamlKey(String line, String repo) {
        Matcher matcher = PTN.matcher(new RequestLineFrom(line).uri().getPath());
        if (!matcher.matches()) {
            throw new UnsupportedOperationException("Unsupported request");
        }
        return new Key.From(String.format("%s%s.yaml", Optional.ofNullable(matcher.group("second")).map(present -> String.format("%s/", matcher.group("first"))).orElse(""), repo));
    }

    private static YamlMapping yaml() {
        return Yaml.createYamlMappingBuilder().add("repo", (YamlNode)Yaml.createYamlMappingBuilder().add("type", "docker").add("storage", "default").add("permissions", (YamlNode)Yaml.createYamlMappingBuilder().add("*", (YamlNode)Yaml.createYamlSequenceBuilder().add("*").build()).build()).build()).build();
    }
}

