/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.common.RsJson;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.reactivestreams.Publisher;

public final class ApiRepoListSlice
implements Slice {
    private static final Pattern PTN = Pattern.compile("/api/repos/(?<user>[^/.]+)");
    private final Storage storage;

    public ApiRepoListSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Matcher matcher = PTN.matcher(new RequestLineFrom(line).uri().getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException("Should match");
        }
        String user = matcher.group("user");
        RxStorageWrapper rxstorage = new RxStorageWrapper(this.storage);
        return new AsyncResponse(rxstorage.list((Key)new Key.From(user)).map(repos -> {
            JsonObjectBuilder json = Json.createObjectBuilder().add("user", user);
            JsonArrayBuilder arr = Json.createArrayBuilder();
            for (Key key : repos) {
                arr.add(key.string().replace(".yaml", ""));
            }
            json.add("repositories", arr);
            return json;
        }).map(builder -> new RsJson(() -> ((JsonObjectBuilder)builder).build())));
    }
}

