/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.dashboard;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.management.dashboard.Page;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.io.TemplateLoader;
import io.reactivex.Single;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;

public final class UserPage
implements Page {
    private static final Pattern PTN = Pattern.compile("/dashboard/(?<user>[^/.]+)/?");
    private final Handlebars handlebars;
    private final Storage storage;

    public UserPage(TemplateLoader tpl, Storage storage) {
        this.handlebars = new Handlebars(tpl);
        this.storage = storage;
    }

    @Override
    public Single<String> render(String line, Iterable<Map.Entry<String, String>> headers) {
        Matcher matcher = PTN.matcher(new RequestLineFrom(line).uri().getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException("Should match");
        }
        String user = matcher.group("user");
        return new RxStorageWrapper(this.storage).list((Key)new Key.From(user)).map(repos -> this.handlebars.compile("user").apply((Object)new MapOf(new Map.Entry[]{new MapEntry((Object)"title", (Object)user), new MapEntry((Object)"user", (Object)user), new MapEntry((Object)"repos", repos.stream().map(key -> key.string().replace(".yaml", "")).collect(Collectors.toList()))})));
    }
}

