/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api;

import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.amihaiemil.eoyaml.YamlNode;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.ext.ContentAs;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.management.ConfigFiles;
import com.artipie.management.api.ContentAsYaml;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.reactivestreams.Publisher;

public final class ApiRepoUpdateSlice
implements Slice {
    private static final Pattern PTN = Pattern.compile("/api/repos/(?<user>[^/.]+)");
    private final ConfigFiles configfile;

    public ApiRepoUpdateSlice(ConfigFiles configfile) {
        this.configfile = configfile;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Matcher matcher = PTN.matcher(new RequestLineFrom(line).uri().getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException("Should match");
        }
        String user = matcher.group("user");
        return new AsyncResponse(((Single)Single.just(body).to((Function)ContentAs.STRING)).map(payload -> URLEncodedUtils.parse((String)payload, (Charset)StandardCharsets.UTF_8)).flatMap(form -> {
            String name = form.stream().filter(input -> input.getName().equals("repo")).map(NameValuePair::getValue).findFirst().orElseThrow();
            Key.From key = new Key.From(new String[]{user, String.format("%s.yaml", name)});
            YamlMapping config = Yaml.createYamlInput((String)form.stream().filter(input -> input.getName().equals("config")).map(NameValuePair::getValue).findFirst().orElseThrow()).readYamlMapping();
            return SingleInterop.fromFuture(this.configfile.exists((Key)key).thenCompose(arg_0 -> this.lambda$response$4((Key)key, config, arg_0)).thenCompose(arg_0 -> this.lambda$response$5((Key)key, arg_0)).thenApply(ignore -> new RsWithHeaders((Response)new RsWithStatus(RsStatus.FOUND), (Headers)new Headers.From("Location", String.format("/dashboard/%s/%s", user, name)))));
        }));
    }

    private /* synthetic */ CompletionStage lambda$response$5(Key key, YamlMapping yaml) {
        return this.configfile.save(key, (Content)new Content.From(yaml.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private /* synthetic */ CompletionStage lambda$response$4(Key key, YamlMapping config, Boolean exist) {
        CompletableFuture<YamlMapping> res;
        if (exist.booleanValue()) {
            res = (CompletableFuture<YamlMapping>)((Single)SingleInterop.fromFuture(this.configfile.value(key)).to((Function)new ContentAsYaml())).map(source -> {
                YamlMapping patch = config.yamlMapping("repo");
                YamlMappingBuilder repo = Yaml.createYamlMappingBuilder();
                repo = repo.add("type", source.yamlMapping("repo").value("type"));
                if (patch.value("type") != null) {
                    repo = repo.add("type", patch.value("type"));
                }
                repo = repo.add("storage", source.yamlMapping("repo").value("storage"));
                if (patch.value("storage") != null && Scalar.class.isAssignableFrom(patch.value("storage").getClass())) {
                    repo = repo.add("storage", patch.value("storage"));
                }
                repo = repo.add("permissions", source.yamlMapping("repo").value("permissions"));
                if (patch.value("permissions") != null) {
                    repo = repo.add("permissions", patch.value("permissions"));
                }
                repo = repo.add("settings", source.yamlMapping("repo").value("settings"));
                if (patch.value("permissions") != null) {
                    repo = repo.add("settings", patch.value("settings"));
                }
                return Yaml.createYamlMappingBuilder().add("repo", (YamlNode)repo.build()).build();
            }).to(SingleInterop.get());
        } else {
            YamlMapping repo = config.yamlMapping("repo");
            YamlNode type = repo.value("type");
            if (type == null || !Scalar.class.isAssignableFrom(type.getClass())) {
                throw new IllegalStateException("Repository type required");
            }
            YamlNode stor = repo.value("storage");
            if (stor == null || !Scalar.class.isAssignableFrom(stor.getClass())) {
                throw new IllegalStateException("Repository storage is required");
            }
            res = CompletableFuture.completedFuture(Yaml.createYamlMappingBuilder().add("repo", (YamlNode)Yaml.createYamlMappingBuilder().add("type", type).add("storage", stor).add("permissions", repo.value("permissions")).build()).build());
        }
        return res;
    }
}

