/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api.artifactory;

import com.artipie.http.rq.RequestLineFrom;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FromRqLine {
    private final String rqline;
    private final RqPattern ptrn;

    FromRqLine(String rqline, RqPattern ptrn) {
        this.rqline = rqline;
        this.ptrn = ptrn;
    }

    Optional<String> get() {
        Matcher matcher = this.ptrn.pattern.matcher(new RequestLineFrom(this.rqline).uri().toString());
        Optional<String> username = matcher.matches() ? Optional.of(matcher.group(1)) : Optional.empty();
        return username;
    }

    public static enum RqPattern {
        USER("/api/security/users/(?<username>[^/.]+)"),
        REPO("/api/security/permissions/(?<repo>[^/.]+)"),
        REPOS("/api/security/permissions"),
        CREATE_REPO("/api/repositories/.*");

        private final Pattern pattern;

        private RqPattern(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public Pattern pattern() {
            return this.pattern;
        }
    }
}

