/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management;

import com.artipie.http.auth.Authentication;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;

public interface Users {
    public CompletionStage<List<User>> list();

    public CompletionStage<Void> add(User var1, String var2, PasswordFormat var3);

    public CompletionStage<Void> remove(String var1);

    public CompletionStage<Authentication> auth();

    public static final class User {
        private final String uname;
        private final Optional<String> mail;
        private final Set<String> ugroups;

        public User(String name, Optional<String> mail, Set<String> groups) {
            this.uname = name;
            this.mail = mail;
            this.ugroups = groups;
        }

        public User(String name, Optional<String> email) {
            this(name, email, Collections.emptySet());
        }

        public User(String name) {
            this(name, Optional.empty(), Collections.emptySet());
        }

        public String name() {
            return this.uname;
        }

        public Optional<String> email() {
            return this.mail;
        }

        public Set<String> groups() {
            return this.ugroups;
        }

        public boolean equals(Object other) {
            boolean res;
            if (this == other) {
                res = true;
            } else if (other == null || this.getClass() != other.getClass()) {
                res = false;
            } else {
                User user = (User)other;
                res = Objects.equals(this.uname, user.uname) && Objects.equals(this.mail, user.mail) && Objects.equals(this.ugroups, user.ugroups);
            }
            return res;
        }

        public int hashCode() {
            return Objects.hash(this.uname, this.mail, this.ugroups);
        }
    }

    public static enum PasswordFormat {
        PLAIN,
        SHA256;

    }
}

