/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api;

import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.amihaiemil.eoyaml.YamlNode;
import com.artipie.asto.Concatenation;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.management.ConfigFiles;
import com.artipie.management.api.RsYaml;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class ApiRepoGetSlice
implements Slice {
    private static final Pattern PTN = Pattern.compile("/api/repos/(?<key>[^/.]+/[^/.]+)");
    private final ConfigFiles configfile;

    public ApiRepoGetSlice(ConfigFiles configfile) {
        this.configfile = configfile;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Matcher matcher = PTN.matcher(new RequestLineFrom(line).uri().getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException("Should match");
        }
        String name = matcher.group("key");
        Key.From key = new Key.From(String.format("%s.yaml", name));
        return new AsyncResponse(SingleInterop.fromFuture(this.configfile.exists((Key)key)).filter(exists -> exists).flatMapSingleElement(ignore -> SingleInterop.fromFuture(this.configfile.value((Key)key)).flatMap(pub -> new Concatenation((Publisher)pub).single()).map(data -> Yaml.createYamlInput((String)new String(new Remaining(data).bytes(), StandardCharsets.UTF_8)).readYamlMapping()).map(config -> {
            YamlMapping repo = config.yamlMapping("repo");
            YamlMappingBuilder builder = Yaml.createYamlMappingBuilder();
            builder = builder.add("type", repo.value("type"));
            if (repo.value("storage") != null && Scalar.class.isAssignableFrom(repo.value("storage").getClass())) {
                builder = builder.add("storage", repo.value("storage"));
            }
            builder = builder.add("permissions", repo.value("permissions"));
            return Yaml.createYamlMappingBuilder().add("repo", (YamlNode)builder.build()).build();
        }).map(RsYaml::new)).switchIfEmpty((SingleSource)Single.just((Object)new RsWithStatus(RsStatus.NOT_FOUND))));
    }
}

