/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api.artifactory;

import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.management.RepoPermissions;
import com.artipie.management.api.artifactory.FromRqLine;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.cactoos.list.ListOf;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;
import org.reactivestreams.Publisher;

public final class AddUpdatePermissionSlice
implements Slice {
    private static final Map<String, String> MAPPING = new MapOf(new Map.Entry[]{new MapEntry((Object)"r", (Object)"read"), new MapEntry((Object)"read", (Object)"read"), new MapEntry((Object)"w", (Object)"write"), new MapEntry((Object)"write", (Object)"write"), new MapEntry((Object)"deploy", (Object)"write"), new MapEntry((Object)"m", (Object)"*"), new MapEntry((Object)"admin", (Object)"*"), new MapEntry((Object)"manage", (Object)"*"), new MapEntry((Object)"d", (Object)"delete"), new MapEntry((Object)"delete", (Object)"delete")});
    private final RepoPermissions permissions;

    public AddUpdatePermissionSlice(RepoPermissions permissions) {
        this.permissions = permissions;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Optional<String> opt = new FromRqLine(line, FromRqLine.RqPattern.REPO).get();
        return opt.map(repo -> new AsyncResponse(new PublisherAs(body).bytes().thenApply(bytes -> Json.createReader((InputStream)new ByteArrayInputStream((byte[])bytes)).readObject()).thenCompose(json -> this.update((JsonObject)json, (String)repo).thenApply(success -> {
            Object result = success != false ? StandardRs.EMPTY : new RsWithStatus(RsStatus.BAD_REQUEST);
            return result;
        })))).orElse((Response)new RsWithStatus(RsStatus.BAD_REQUEST));
    }

    private CompletionStage<Boolean> update(JsonObject json, String name) {
        JsonObject repo = json.getJsonObject("repo");
        String actions = "actions";
        List<RepoPermissions.PermissionItem> res = Stream.concat(Stream.of(new RepoPermissions.PermissionItem("/readers", (List<String>)new ListOf((Object[])new String[]{"read"}))), Stream.concat(AddUpdatePermissionSlice.permsFromJson(Optional.ofNullable(repo.getJsonObject("actions").getJsonObject("users")), ""), AddUpdatePermissionSlice.permsFromJson(Optional.ofNullable(repo.getJsonObject("actions").getJsonObject("groups")), "/"))).distinct().collect(Collectors.toList());
        List<RepoPermissions.PathPattern> patterns = Optional.ofNullable(repo.getJsonArray("include-patterns")).map(array -> array.getValuesAs(JsonString.class)).orElse(Collections.emptyList()).stream().map(JsonString::getString).map(RepoPermissions.PathPattern::new).collect(Collectors.toList());
        CompletionStage<Boolean> result = patterns.stream().allMatch(ptrn -> ptrn.valid(name)) ? this.permissions.update(name, res, patterns).thenApply(nothing -> true) : CompletableFuture.completedFuture(false);
        return result;
    }

    private static Stream<RepoPermissions.PermissionItem> permsFromJson(Optional<JsonObject> perms, String prefix) {
        return perms.map(items -> items.entrySet().stream()).map(items -> items.map(json -> new RepoPermissions.PermissionItem(String.format("%s%s", prefix, json.getKey()), ((JsonValue)json.getValue()).asJsonArray().stream().map(item -> item.toString().replace("\"", "")).map(item -> Optional.ofNullable(MAPPING.get(item)).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported permission '%s'!", item)))).distinct().collect(Collectors.toList())))).orElse(Stream.empty());
    }
}

