/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api.artifactory;

import com.artipie.asto.Key;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public final class KeyList {
    private final Key root;
    private final Set<Key> keys;

    public KeyList(Key root) {
        this.root = root;
        this.keys = new HashSet<Key>();
    }

    public void add(Key key) {
        this.keys.add(key);
        key.parent().ifPresent(this::add);
    }

    public <T> T print(KeysFormat<T> format) {
        ArrayList<Key> list = new ArrayList<Key>(this.keys);
        list.sort(Comparator.comparing(Key::string));
        PeekingIterator iter = Iterators.peekingIterator(list.iterator());
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            if (!key.parent().map(this.root::equals).orElse(false).booleanValue()) continue;
            format.add(key, iter.hasNext() && ((Key)iter.peek()).parent().map(parent -> parent.equals(key)).orElse(false) != false);
        }
        return format.result();
    }

    public static interface KeysFormat<T> {
        public void add(Key var1, boolean var2);

        public T result();
    }
}

