/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management;

import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlSequenceBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public interface RepoPermissions {
    public CompletionStage<List<String>> repositories();

    public CompletionStage<Void> remove(String var1);

    public CompletionStage<Void> update(String var1, Collection<PermissionItem> var2, Collection<PathPattern> var3);

    public CompletionStage<Collection<PermissionItem>> permissions(String var1);

    public CompletionStage<Collection<PathPattern>> patterns(String var1);

    public static final class PathPattern {
        private final String expr;

        public PathPattern(String expr) {
            this.expr = expr;
        }

        public String string() {
            return this.expr;
        }

        public boolean valid(String repo) {
            return this.expr.matches(String.format("(%s/)?(\\*\\*)*(/\\*)?", repo));
        }
    }

    public static final class PermissionItem {
        private final String name;
        private final List<String> perms;

        public PermissionItem(String name, List<String> permissions) {
            this.name = name;
            this.perms = permissions;
        }

        public PermissionItem(String name, String permission) {
            this(name, Collections.singletonList(permission));
        }

        public String username() {
            return this.name;
        }

        public List<String> permissions() {
            return this.perms;
        }

        public boolean equals(Object other) {
            boolean res;
            if (this == other) {
                res = true;
            } else if (other == null || this.getClass() != other.getClass()) {
                res = false;
            } else {
                PermissionItem that = (PermissionItem)other;
                res = Objects.equals(this.name, that.name) && Objects.equals(this.perms, that.perms);
            }
            return res;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.perms);
        }

        public YamlSequenceBuilder yaml() {
            YamlSequenceBuilder res = Yaml.createYamlSequenceBuilder();
            for (String item : this.perms) {
                res = res.add(item);
            }
            return res;
        }
    }
}

